(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     79282,       2376]*)
(*NotebookOutlinePosition[     90573,       2696]*)
(*  CellTagsIndexPosition[     89931,       2671]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Undo", "Command",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Undo", "SR"],
  " reverses the previous action."
}], "Usage",
  CellTags->"Undo"],

Cell[TextData[
"\[FilledSmallSquare] You can only undo your most recent command. In general, \
you can undo the basic commands in the Edit menu, and any amount of typing \
you have done since your last action. "], "Notes",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "The only way to undo several actions at once is to go back to an earlier \
version of your file: close the file, click No when asked if you want to save \
the changes, then reopen it. The notebook then reverts to the last version \
saved. "
}], "Notes",
  CellTags->"Undo"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["z", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["z", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["z", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Undo"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cut", "Command",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cut", "SR"],
  " deletes the current selection and puts it in the Clipboard. "
}], "Usage",
  CellTags->"Cut"],

Cell[TextData[
"\[FilledSmallSquare] To cut selected material from the notebook and place it \
in the Clipboard:"], "Text",
  CellTags->"Cut"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Highlight the area to be cut. \n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Choose ",
  StyleBox["Cut", "SR"],
  " from the Edit menu."
}], "ItemizedText",
  CellTags->"Cut"],

Cell[TextData[{
  "You can then insert the deleted material elsewhere using the ",
  StyleBox["Paste", "SR"],
  " command."
}], "NotesList",
  CellTags->"Cut"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["x", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["x", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["x", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Cut"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copy", "Command",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy", "SR"],
  " copies the current selection to the Clipboard without deleting it from \
your notebook."
}], "Usage",
  CellTags->"Copy"],

Cell[TextData[
"\[FilledSmallSquare] To copy selected material from the notebook and place \
it in the Clipboard:"], "Notes",
  CellTags->"Copy"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Highlight the area to be copied. \n",
  StyleBox["2. ",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Copy", "SR"],
  " from the Edit menu."
}], "ItemizedText",
  CellTags->"Copy"],

Cell[TextData[{
  "The copied text or cells can then be inserted in another notebook or \
elsewhere in the same notebook with the ",
  StyleBox["Paste", "SR"],
  " command."
}], "NotesList",
  CellTags->"Copy"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["c", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Copy"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Paste", "Command",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Paste", "SR"],
  " inserts the current contents of the Clipboard."
}], "Usage",
  CellTags->"Paste"],

Cell[TextData[
"\[FilledSmallSquare] To insert the Clipboard contents inside an existing \
cell: "], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["1. ",
    FontWeight->"Bold"],
  " Position the text insertion point (blinking vertical bar) by clicking the \
desired area. \n",
  StyleBox["2. ",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Paste", "SR"],
  "."
}], "ItemizedText",
  CellTags->"Paste"],

Cell[TextData[
"\[FilledSmallSquare] To insert the Clipboard contents between two cells, or \
at the bottom or top of the notebook: "], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["1. ",
    FontWeight->"Bold"],
  " Position the cell insertion point (horizontal bar) in the desired area \
between two cells. \n",
  StyleBox["2. ",
    FontWeight->"Bold"],
  " Choose ",
  StyleBox["Paste", "SR"],
  "."
}], "ItemizedText",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  pastes a copy of the Clipboard contents at the insertion point."
}], "NotesList",
  CellTags->"Paste"],

Cell[TextData[
"\[FilledSmallSquare] To replace a selected area with the Clipboard \
contents:"], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Select a range of characters or cells by highlighting them.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Choose ",
  StyleBox["Paste", "SR"],
  "."
}], "ItemizedText",
  CellTags->"Paste"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " deletes the selected characters or cells and inserts the new material in \
their place."
}], "NotesList",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] Information contained in the Clipboard remains there \
until a new selection is copied or cut. This lets you paste the same contents \
repeatedly. Large clipboards take up memory, however. To empty the Clipboard \
automatically after pasting, use the ",
  StyleBox["Paste and Discard", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "command."
}], "Notes",
  CellTags->"Paste"],

Cell[TextData[
"\[FilledSmallSquare] When pasting a notebook or cell expression from a text \
application such as email, a dialog box gives you the choice of pasting the \
expression literally into the current notebook or interpreting it as a cell \
or notebook."], "Notes",
  CellTags->"Paste"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["v", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Paste"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clear", "Command",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Clear", "SR"],
  " deletes the current selection without putting it in the Clipboard."
}], "Usage",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] Unlike",
  StyleBox[" Cut ", "MR"],
  "and",
  StyleBox[" Copy", "MR"],
  ", this command does not place the selection in the Clipboard."
}], "Notes",
  CellTags->"Clear"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[DeleteKey] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["X", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["X\[RightModified]", "C1MR"],
  StyleBox[" (X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Clear"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Paste and Discard", "Command",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Paste and Discard", "SR"],
  " transfers the contents of the Clipboard into the current insertion point, \
leaving the Clipboard empty."
}], "Usage",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] When the Clipboard is extremely large and memory is \
short, you can paste with this command to avoid duplicating the contents of \
the Clipboard. Unlike the ",
  StyleBox["Paste", "SR"],
  " command, ",
  StyleBox["Paste and Discard", "SR"],
  " cannot be repeated, since it empties the Clipboard."
}], "Notes",
  CellTags->"PasteDiscard"],

Cell[TextData[{
  "\[FilledSmallSquare] By using ",
  StyleBox["Cut", "SR"],
  " in combination with ",
  StyleBox["Paste and Discard,", "SR"],
  " you can transfer large blocks of cells between notebooks without taking \
up additional memory."
}], "Notes",
  CellTags->"PasteDiscard"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copy As", "Command",
  CellTags->"CopySpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Copy As", "SR"],
  " copies a selection and converts it to the specified format."
}], "Usage",
  CellTags->"CopySpecial"],

Cell[TextData[
"\[FilledSmallSquare] Selections can be copied in the following formats:\n   \
Text, Input Text, Cell Expression, Notebook Expression, and Complete \
Notebook.\n   On Macintosh also: PICT, Bitmap PICT, PICT with Embedded \
PostScript, and QuickTime."], "Notes",
  CellTags->"CopySpecial"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Save Selection As", "Command",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save Selection As", "SR"],
  " writes out the selection in a file with the specified file format."
}], "Usage",
  CellTags->"SelectionSaveSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] Selections can be saved in the following formats:\n   \
Text, Input Text, Cell Expression, Notebook Expression, Complete Notebook, \
Package Format, EPS, Adobe Illustrator, and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Bitmap Form (MGF).\n   On Macintosh also: PICT, Bitmap PICT, PICT with \
Embedded PostScript, and QuickTime."
}], "Notes",
  CellTags->"SelectionSaveSpecial"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Select All", "Command",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Select All", "SR"],
  " selects all cells in the current notebook."
}], "Usage",
  CellTags->"SelectAll"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["a", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["a", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["A\[RightModified]", "C1MR"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SelectAll"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Insert Object", "Command",
  CellTags->"InsertObject"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Insert Object", "SR"],
  " inserts an embedded object, such as a document file, in the current \
notebook. (Microsoft Windows only.)"
}], "Usage",
  CellTags->"InsertObject"]
}, Open  ]],

Cell[TextData[StyleBox["Create New",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["Inserts a new object that you can create.", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Object Type",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Click the type of information you want to insert. Some common object types \
include documents, bitmaps, and spreadsheets.\
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Create from File",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["Inserts an existing object.", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["File",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Type the name of the file you want to insert as an embedded object, or click \
the Browse button to locate additional files.\
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Browse",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Opens the Browse dialog box, where you can locate the file that you want to \
insert. \
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Link",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Creates a link to the selected file rather than embedding it.\
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell["Display As Icon", "DialogItem",
  CellTags->"InsertObject"],

Cell["Displays the embedded object as an icon.", "IndentedText",
  CellTags->"InsertObject"],

Cell[TextData[StyleBox["Change Icon",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"InsertObject"],

Cell["\<\
Changes the icon that represents an embedded object. This button appears only \
if you click the Display As Icon check box.\
\>", "IndentedText",
  CellTags->"InsertObject"],

Cell["Result", "DialogItem",
  CellTags->"InsertObject"],

Cell["Describes the result of the selected options.", "IndentedText",
  CellTags->"InsertObject"],

Cell[CellGroupData[{

Cell["Motion", "Command",
  CellTags->"Motion"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Motion", "SR"],
  " submenu provides menu commands for commonly used cursor movements. This \
menu is intended primarily as a reference until you learn the keyboard \
commands."
}], "Usage",
  CellTags->{"Motion", "all"}],

Cell["", "Notes",
  CellTags->"Motion"]
}, Open  ]],

Cell[TextData[{
  "Windows Motion ",
  StyleBox["Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"Motion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortRightArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[ShortLeftArrow]",
                FontSize->12]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[\(\[DeleteKey]\ \),
                FontSize->12]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Backspace",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                \(\[ControlKey]\[LeftModified] \[ShortRightArrow] 
                  \[RightModified]\),
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    "2ColumnSmallBox"], "\[SkeletonIndicator]", 
                  StyleBox["\[DeleteKey]",
                    "2ColumnSmallBox"]}]]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], "\[SkeletonIndicator]", 
                  StyleBox["B",
                    "2ColumnSmallBox"], "ackspace"}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["End",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["Home",
                "2ColumnSmallBox"]},
            {
              StyleBox[\(Move\ Next\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[DownArrow]",
                FontSize->12]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox["\[UpArrow]",
                FontSize->12]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"Motion", "all"}],

Cell[TextData[{
  "Macintosh / NeXT Motion ",
  StyleBox["Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"Motion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]f\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]b\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]d\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]h\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontSize->12], " "}]]}],
                FontSize->12]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["Shift",
                        FontFamily->"Helvetica",
                        FontSize->10,
                        FontWeight->"Plain"], 
                      StyleBox["\[KeyBar]\[CommandKey]\[SkeletonIndicator]",
                        FontSize->12], 
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]W\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[OptionKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[CommandKey]\[SkeletonIndicator]",
                        FontSize->12], 
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]w\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[OptionKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["Shift",
                      FontFamily->"Helvetica",
                      FontSize->10,
                      FontWeight->"Plain"], 
                    StyleBox["\[SkeletonIndicator]",
                      FontSize->12], 
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]W\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], 
                  StyleBox["\[LeftModified]w\[RightModified]",
                    FontSize->12]}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]e\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[CommandKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]a\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[CommandKey]\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Next\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]n\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[DownArrow]",
                    FontSize->12]}]}]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]p\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[UpArrow]",
                    FontSize->12]}]}]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"Motion", "all"}],

Cell[TextData[{
  "X Motion",
  StyleBox[" Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"Motion", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox[\(Move\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]f\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]b\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10]}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]d\[RightModified]",
                        FontSize->12]}]], " "}],
                FontSize->12]},
            {
              StyleBox[\(Delete\ Previous\ Character\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]h\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontSize->12], " "}]]}],
                FontSize->12]},
            {
              StyleBox[\(Move\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox["Shift",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontFamily->"Helvetica",
                    FontSize->10,
                    FontWeight->"Plain"], 
                  StyleBox["\[KeyBar]",
                    FontSize->12], 
                  StyleBox["\[Mod1Key]",
                    FontSize->12], 
                  StyleBox[
                    RowBox[{
                      StyleBox["\[KeyBar]\[ControlKey]",
                        FontSize->12], "\[LeftModified]", 
                      StyleBox["W",
                        "2ColumnSmallBox"], "\[RightModified]"}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], "\[Mod2Key]", "\[LeftModified]"}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox["\[Mod1Key]",
                    FontSize->12], 
                  StyleBox[
                    RowBox[{"\[ControlKey]", 
                      StyleBox["\[LeftModified]w\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[Mod2Key]",
                    FontSize->12], 
                  StyleBox["\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Next\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["Shift",
                      FontFamily->"Helvetica",
                      FontSize->10,
                      FontWeight->"Plain"], 
                    StyleBox["\[SkeletonIndicator]",
                      FontSize->12], 
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]W\[RightModified]",
                      FontSize->12]}]], 
                StyleBox[" ",
                  FontSize->12]}]},
            {
              StyleBox[\(Delete\ Previous\ Word\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  StyleBox["\[ControlKey]",
                    FontFamily->"Helvetica",
                    FontSize->12,
                    FontWeight->"Plain"], 
                  StyleBox["\[LeftModified]w\[RightModified]",
                    FontSize->12]}]]},
            {
              StyleBox[\(Move\ Line\ End\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]e\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[Mod1Key]",
                    FontSize->12], 
                  StyleBox["\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortRightArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Line\ Beginning\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["\[ControlKey]",
                        FontFamily->"Helvetica",
                        FontSize->12,
                        FontWeight->"Plain"], 
                      StyleBox["\[LeftModified]a\[RightModified]",
                        FontSize->12]}]], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[Mod1Key]",
                    FontSize->12], 
                  StyleBox["\[LeftModified]",
                    FontSize->12]}], 
                StyleBox["\[ShortLeftArrow]",
                  FontSize->12], 
                StyleBox["\[RightModified]",
                  FontSize->12]}]},
            {
              StyleBox[\(Move\ Next\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]n\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[DownArrow]",
                    FontSize->12]}]}]},
            {
              StyleBox[\(Move\ Previous\ Line\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[ControlKey]",
                      FontFamily->"Helvetica",
                      FontSize->12,
                      FontWeight->"Plain"], 
                    StyleBox["\[LeftModified]p\[RightModified]",
                      FontSize->12]}]], 
                StyleBox["  ",
                  FontSize->12], 
                RowBox[{
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["\[UpArrow]",
                    FontSize->12]}]}]}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, True, False, False, False, True, 
              False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"Motion", "all"}],

Cell["", "Notes",
  AspectRatioFixed->False,
  CellTags->{"editmotion", "all"}],

Cell[CellGroupData[{

Cell["\<\

Expression Input\
\>", "Command",
  CellTags->"ExpressionInput"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Expression Input", "SR"],
  " submenu provides menu commands for the most common expression typesetting \
actions. This menu is intended primarily as a reference until you learn the \
keyboard commands."
}], "Usage",
  CellTags->"ExpressionInput"],

Cell["", "Notes",
  CellTags->"ExpressionInput"],

Cell[TextData[{
  "Windows Expression Input ",
  StyleBox["Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "   ", 
                    "\[ControlKey]\[LeftModified]"}]}], "=", 
                "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                \(\[ControlKey]\[LeftModified]@\[RightModified]\), "  ", 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], "  ", 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[ReturnKey]"},
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], \(\[ControlKey]\[LeftModified]\ , 
              \[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[SkeletonIndicator]\[SpaceKey]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\  . \[RightModified]\ \)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", " ", 
                  RowBox[{"\[RightModified]", "  ", 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], "  ", 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              \(\[ControlKey]\[LeftModified]\ )\), "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Insert\ Raw\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", "  ", 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], "  ", 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified] \[ShortLeftArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified] \[ShortRightArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified]\[DownArrow]\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[AltKey]\[LeftModified]\[UpArrow]\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"editexpression", "all"}],

Cell[TextData[{
  "Macintosh/ NeXT Expression Input",
  StyleBox[" ", "MR",
    FontWeight->"Plain"],
  StyleBox["Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], "\[ControlKey]\[LeftModified]"}]}], "=", 
                "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                "\[ControlKey]\[LeftModified]\[ReturnKey]\[RightModified]"}]},
            
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], \(\[ControlKey]\[LeftModified]\ , 
              \[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]\[SpaceKey]\[RightModified]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\  . \[RightModified]\ \)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", " ", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              \(\[ControlKey]\[LeftModified]\ )\), "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Insert\ Raw\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortRightArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\[DownArrow]\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\[UpArrow]\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"editexpression", "all"}],

Cell[TextData[{
  "X Expression Input",
  StyleBox[" Submenu",
    FontWeight->"Plain"]
}], "Subsubsection",
  GridBoxOptions->{RowLines->False},
  CellTags->{"editexpression", "all"}],

Cell[BoxData[
    StyleBox[
      FrameBox[GridBox[{
            {
              StyleBox["Action",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}], 
              StyleBox["Keys",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Bold",
                FontSlant->"Plain",
                FontTracking->"Plain",
                PrivateFontOptions->{"FontPostScriptName"->Automatic}]},
            {
              StyleBox["Superscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", 
                  StyleBox["^",
                    FontFamily->"Helvetica",
                    FontWeight->"Plain"], "\[RightModified]"}], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]6\[RightModified]"}]},
            {
              StyleBox["Subscript",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] - \[RightModified]\)},
            {
              StyleBox["Above",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]7\[RightModified]"},
            {
              StyleBox["Below",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{"\[ControlKey]\[LeftModified]", "+", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], "\[ControlKey]\[LeftModified]"}]}], "=", 
                "\[RightModified]"}]},
            {
              StyleBox[\(Opposite\ Position\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "%", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                "\[ControlKey]\[LeftModified]5\[RightModified]"}]},
            {
              StyleBox["Fraction",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]/\[RightModified]\)},
            {
              StyleBox["Radical",
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                RowBox[{\(\[ControlKey]\[LeftModified]@\[RightModified]\), 
                  StyleBox["  ",
                    FontSize->12], 
                  StyleBox["or",
                    FontFamily->"Helvetica",
                    FontSize->10], 
                  StyleBox["  ",
                    FontSize->12], 
                  "\[ControlKey]\[LeftModified]2\[RightModified]"}], " "}]},
            {
              StyleBox[\(Add\ Row\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox[" ",
                  FontFamily->"Helvetica",
                  FontWeight->"Plain"], 
                "\[ControlKey]\[LeftModified]\[ReturnKey]\[RightModified]"}]},
            
            {
              StyleBox[\(Add\ Column\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], \(\[ControlKey]\[LeftModified]\ , 
              \[RightModified]\)},
            {
              StyleBox[\(End\ Subexpression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              "\[ControlKey]\[LeftModified]\[SpaceKey]\[RightModified]"},
            {
              StyleBox[\(Extend\ Selection\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\  . \[RightModified]\ \)},
            {
              StyleBox[\(Start\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{"\[ControlKey]\[LeftModified]", 
                RowBox[{"(", " ", 
                  RowBox[{"\[RightModified]", 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox["or",
                      FontFamily->"Helvetica",
                      FontSize->10], 
                    StyleBox["  ",
                      FontSize->12], 
                    StyleBox[
                      RowBox[{"\[ControlKey]\[LeftModified]", 
                        StyleBox["9",
                          FontFamily->"Helvetica",
                          FontWeight->"Plain"], "\[RightModified]"}]]}]}]}]},
            {
              StyleBox[\(End\ Inline\ Cell\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              \(\[ControlKey]\[LeftModified]\ )\), "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["0",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Insert\ Raw\ Expression\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              RowBox[{
              "\[ControlKey]\[LeftModified]", "*", "\[RightModified]", 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox["or",
                  FontFamily->"Helvetica",
                  FontSize->10], 
                StyleBox["  ",
                  FontSize->12], 
                StyleBox[
                  RowBox[{"\[ControlKey]\[LeftModified]", 
                    StyleBox["8",
                      FontFamily->"Helvetica",
                      FontWeight->"Plain"], "\[RightModified]"}]]}]},
            {
              StyleBox[\(Nudge\ Left\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortLeftArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Right\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified] \[ShortRightArrow] 
                \[RightModified]\)},
            {
              StyleBox[\(Nudge\ Down\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\[DownArrow]\[RightModified]\)},
            {
              StyleBox[\(Nudge\ Up\),
                FontFamily->"Helvetica",
                FontSize->10,
                FontWeight->"Plain"], 
              \(\[ControlKey]\[LeftModified]\[UpArrow]\[RightModified]\)}
            },
          GridFrame->False,
          
          RowLines->{
            True, False, False, False, False, True, False, True, False, True, 
              False, True, False, False, True, False},
          ColumnLines->False],
        BoxMargins->True],
      "2ColumnSmallBox"]], "Text",
  CellTags->{"editexpression", "all"}],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 1.10.2",
    ButtonData:>{"1.10.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"ExpressionInput"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spanning Characters", "Command",
  CellTags->"Spanning"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Spanning Characters", "SR"],
  " submenu provides menu commands for controlling the height of expandable \
characters. "
}], "Usage",
  CellTags->"Spanning"],

Cell[TextData[
"\[FilledSmallSquare] Examples are parentheses, which by default are taken to \
expand so as to span any expression they contain. "], "Notes",
  CellTags->"Spanning"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.8.11",
    ButtonData:>{"2.8.11"},
    ButtonStyle->"MainBookLink"],
  " on ",
  StyleBox["SpanMinSize", "MR"],
  ", ",
  StyleBox["SpanMaxSize", "MR"],
  ", ",
  StyleBox["SpanSymmetric", "MR"],
  " and ",
  StyleBox["SpanLineThickness", "MR"],
  "."
}], "Notes",
  CellTags->"Spanning"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Insert Raw Expression", "Command",
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Insert Raw Expression", "SR"],
  " gives you a dialog box for pasting a  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " InputForm expression directly into your notebook."
}], "Usage",
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] This command is intended for advanced users who are \
familiar with the expression syntax of elements in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  The text entered in this dialog must be the correct underlying \
expression representing the desired element."
}], "Notes",
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["*", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox[" or ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["8", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["*", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox[" or ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["8", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["*", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox[" or ", "Notes"],
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["8", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"InsertRaw"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.10.1",
    ButtonData:>{"2.10.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"InsertRaw"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Make 2D", "Command",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Make 2D", "SR"],
  " converts linear syntax expressions that were entered directly from the \
keyboard into two-dimensional form."
}], "Usage",
  CellTags->"Make2D"],

Cell[TextData[{
  "\[FilledSmallSquare] For example,",
  StyleBox[" \\!\\(c\\_2\\)", "MR"],
  " becomes ",
  Cell[BoxData[
      \(2\^2\)], "Input"],
  "."
}], "Notes",
  CellTags->"Make2D"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["Y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["Y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["Y", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Make2D"],

Cell[CellGroupData[{

Cell["Check Balance", "Command",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Check Balance", "SR"],
  " expands the selection to cover the nearest pair of matched bracketing \
characters. This command selects nested (",
  StyleBox["e.g",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"ExtraLight"],
  ", parenthesized) expressions outward from the insertion point."
}], "Usage",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "To select a nested expression:"
}], "Notes",
  CellTags->"Balance"],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  Select anywhere within the expression by clicking.\n",
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Choose ",
  StyleBox["Check Balance", "SR"],
  ".\n",
  StyleBox["3.",
    FontWeight->"Bold"],
  "  Repeat to expand the selection to the next pair of enclosing \
parentheses, brackets, or braces."
}], "ItemizedText",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] Each time you choose ",
  StyleBox["Check Balance", "SR"],
  ", ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " expands the selection in both directions until it finds pairs of matching \
parentheses, brackets, or braces: ([{}]). Repeating the command expands the \
selection one level at a time."
}], "Notes",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] You can use the ",
  StyleBox["Check Balance", "SR"],
  " command to check the structure of mathematical expressions. If you have \
unbalanced parentheses, for example, or parentheses incorrectly balanced with \
brackets or braces, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  beeps. (Choose ",
  StyleBox["Why the Beep?", "SR"],
  " to identify the mistake.)  If you position the insertion point (blinking \
vertical bar) inside a bracketed expression and choose ",
  StyleBox["Check Balance", "SR"],
  ", ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " should select the whole expression. If not, you have a missing bracket \
somewhere."
}], "Notes",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " cannot balance a selection that spans more than one cell."
}], "Notes",
  CellTags->"Balance"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["B", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["B", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["B", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Balance"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preferences...", "Command",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Preferences", "SR"],
  " opens the ",
  StyleBox["Option Inspector", "MR"],
  " showing settings for global preferences."
}], "Usage",
  CellTags->"OptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Option Inspector",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"OptionsDialog"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 550}},
CellGrouping->Manual,
WindowSize->{507, 352},
WindowMargins->{{15, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Undo"->{
    Cell[1731, 51, 43, 1, 35, "Command",
      CellTags->"Undo"],
    Cell[1777, 54, 136, 5, 32, "Usage",
      CellTags->"Undo"],
    Cell[1916, 61, 242, 4, 42, "Notes",
      CellTags->"Undo"],
    Cell[2161, 67, 319, 7, 59, "Notes",
      CellTags->"Undo"],
    Cell[2483, 76, 583, 18, 25, "Notes",
      CellTags->"Undo"]},
  "Cut"->{
    Cell[3103, 99, 41, 1, 35, "Command",
      CellTags->"Cut"],
    Cell[3147, 102, 165, 5, 32, "Usage",
      CellTags->"Cut"],
    Cell[3315, 109, 142, 3, 25, "Text",
      CellTags->"Cut"],
    Cell[3460, 114, 243, 10, 50, "ItemizedText",
      CellTags->"Cut"],
    Cell[3706, 126, 159, 5, 27, "NotesList",
      CellTags->"Cut"],
    Cell[3868, 133, 582, 18, 25, "Notes",
      CellTags->"Cut"]},
  "Copy"->{
    Cell[4487, 156, 43, 1, 35, "Command",
      CellTags->"Copy"],
    Cell[4533, 159, 194, 6, 32, "Usage",
      CellTags->"Copy"],
    Cell[4730, 167, 145, 3, 25, "Notes",
      CellTags->"Copy"],
    Cell[4878, 172, 248, 10, 50, "ItemizedText",
      CellTags->"Copy"],
    Cell[5129, 184, 210, 6, 44, "NotesList",
      CellTags->"Copy"],
    Cell[5342, 192, 583, 18, 25, "Notes",
      CellTags->"Copy"]},
  "Paste"->{
    Cell[5962, 215, 45, 1, 35, "Command",
      CellTags->"Paste"],
    Cell[6010, 218, 155, 5, 32, "Usage",
      CellTags->"Paste"],
    Cell[6168, 225, 130, 3, 25, "Notes",
      CellTags->"Paste"],
    Cell[6301, 230, 288, 11, 50, "ItemizedText",
      CellTags->"Paste"],
    Cell[6592, 243, 165, 3, 25, "Notes",
      CellTags->"Paste"],
    Cell[6760, 248, 290, 11, 50, "ItemizedText",
      CellTags->"Paste"],
    Cell[7053, 261, 205, 6, 27, "NotesList",
      CellTags->"Paste"],
    Cell[7261, 269, 127, 3, 25, "Notes",
      CellTags->"Paste"],
    Cell[7391, 274, 257, 10, 50, "ItemizedText",
      CellTags->"Paste"],
    Cell[7651, 286, 228, 7, 27, "NotesList",
      CellTags->"Paste"],
    Cell[7882, 295, 420, 10, 59, "Notes",
      CellTags->"Paste"],
    Cell[8305, 307, 295, 5, 59, "Notes",
      CellTags->"Paste"],
    Cell[8603, 314, 584, 18, 25, "Notes",
      CellTags->"Paste"]},
  "Clear"->{
    Cell[9224, 337, 45, 1, 35, "Command",
      CellTags->"Clear"],
    Cell[9272, 340, 175, 5, 32, "Usage",
      CellTags->"Clear"],
    Cell[9450, 347, 211, 7, 25, "Notes",
      CellTags->"Clear"],
    Cell[9664, 356, 571, 17, 25, "Notes",
      CellTags->"Clear"]},
  "PasteDiscard"->{
    Cell[10272, 378, 64, 1, 35, "Command",
      CellTags->"PasteDiscard"],
    Cell[10339, 381, 232, 6, 49, "Usage",
      CellTags->"PasteDiscard"],
    Cell[10574, 389, 380, 9, 59, "Notes",
      CellTags->"PasteDiscard"],
    Cell[10957, 400, 285, 8, 42, "Notes",
      CellTags->"PasteDiscard"]},
  "CopySpecial"->{
    Cell[11279, 413, 53, 1, 35, "Command",
      CellTags->"CopySpecial"],
    Cell[11335, 416, 176, 5, 32, "Usage",
      CellTags->"CopySpecial"],
    Cell[11514, 423, 303, 5, 71, "Notes",
      CellTags->"CopySpecial"]},
  "SelectionSaveSpecial"->{
    Cell[11854, 433, 72, 1, 35, "Command",
      CellTags->"SelectionSaveSpecial"],
    Cell[11929, 436, 202, 5, 32, "Usage",
      CellTags->"SelectionSaveSpecial"],
    Cell[12134, 443, 434, 9, 88, "Notes",
      CellTags->"SelectionSaveSpecial"]},
  "SelectAll"->{
    Cell[12605, 457, 54, 1, 35, "Command",
      CellTags->"SelectAll"],
    Cell[12662, 460, 160, 5, 32, "Usage",
      CellTags->"SelectAll"],
    Cell[12825, 467, 609, 18, 25, "Notes",
      CellTags->"SelectAll"]},
  "InsertObject"->{
    Cell[13471, 490, 60, 1, 35, "Command",
      CellTags->"InsertObject"],
    Cell[13534, 493, 229, 6, 49, "Usage",
      CellTags->"InsertObject"],
    Cell[13778, 502, 102, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[13883, 506, 93, 1, 23, "IndentedText",
      CellTags->"InsertObject"],
    Cell[13979, 509, 103, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[14085, 513, 182, 4, 40, "IndentedText",
      CellTags->"InsertObject"],
    Cell[14270, 519, 108, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[14381, 523, 79, 1, 23, "IndentedText",
      CellTags->"InsertObject"],
    Cell[14463, 526, 96, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[14562, 530, 184, 4, 40, "IndentedText",
      CellTags->"InsertObject"],
    Cell[14749, 536, 98, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[14850, 540, 146, 4, 23, "IndentedText",
      CellTags->"InsertObject"],
    Cell[14999, 546, 96, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[15098, 550, 121, 3, 23, "IndentedText",
      CellTags->"InsertObject"],
    Cell[15222, 555, 65, 1, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[15290, 558, 92, 1, 23, "IndentedText",
      CellTags->"InsertObject"],
    Cell[15385, 561, 103, 2, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[15491, 565, 183, 4, 40, "IndentedText",
      CellTags->"InsertObject"],
    Cell[15677, 571, 56, 1, 26, "DialogItem",
      CellTags->"InsertObject"],
    Cell[15736, 574, 97, 1, 23, "IndentedText",
      CellTags->"InsertObject"]},
  "Motion"->{
    Cell[15858, 579, 47, 1, 35, "Command",
      CellTags->"Motion"],
    Cell[15908, 582, 280, 7, 49, "Usage",
      CellTags->{"Motion", "all"}],
    Cell[16191, 591, 39, 1, 25, "Notes",
      CellTags->"Motion"],
    Cell[16245, 595, 172, 6, 35, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[16420, 603, 4424, 123, 233, "Text",
      CellTags->{"Motion", "all"}],
    Cell[20847, 728, 181, 6, 35, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[21031, 736, 11912, 314, 253, "Text",
      CellTags->{"Motion", "all"}],
    Cell[32946, 1052, 166, 6, 35, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[33115, 1060, 11964, 318, 253, "Text",
      CellTags->{"Motion", "all"}]},
  "all"->{
    Cell[15908, 582, 280, 7, 49, "Usage",
      CellTags->{"Motion", "all"}],
    Cell[16245, 595, 172, 6, 35, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[16420, 603, 4424, 123, 233, "Text",
      CellTags->{"Motion", "all"}],
    Cell[20847, 728, 181, 6, 35, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[21031, 736, 11912, 314, 253, "Text",
      CellTags->{"Motion", "all"}],
    Cell[32946, 1052, 166, 6, 35, "Subsubsection",
      CellTags->{"Motion", "all"}],
    Cell[33115, 1060, 11964, 318, 253, "Text",
      CellTags->{"Motion", "all"}],
    Cell[45082, 1380, 79, 2, 25, "Notes",
      CellTags->{"editmotion", "all"}],
    Cell[45624, 1404, 190, 6, 35, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[45817, 1412, 7556, 191, 359, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[53376, 1605, 245, 8, 35, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[53624, 1615, 8689, 225, 363, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[62316, 1842, 184, 6, 35, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[62503, 1850, 8689, 225, 363, "Text",
      CellTags->{"editexpression", "all"}]},
  "editmotion"->{
    Cell[45082, 1380, 79, 2, 25, "Notes",
      CellTags->{"editmotion", "all"}]},
  "ExpressionInput"->{
    Cell[45186, 1386, 75, 4, 56, "Command",
      CellTags->"ExpressionInput"],
    Cell[45264, 1392, 306, 7, 66, "Usage",
      CellTags->"ExpressionInput"],
    Cell[45573, 1401, 48, 1, 25, "Notes",
      CellTags->"ExpressionInput"],
    Cell[71195, 2077, 239, 9, 25, "Notes",
      CellTags->"ExpressionInput"]},
  "editexpression"->{
    Cell[45624, 1404, 190, 6, 35, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[45817, 1412, 7556, 191, 359, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[53376, 1605, 245, 8, 35, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[53624, 1615, 8689, 225, 363, "Text",
      CellTags->{"editexpression", "all"}],
    Cell[62316, 1842, 184, 6, 35, "Subsubsection",
      CellTags->{"editexpression", "all"}],
    Cell[62503, 1850, 8689, 225, 363, "Text",
      CellTags->{"editexpression", "all"}]},
  "Spanning"->{
    Cell[71471, 2091, 62, 1, 35, "Command",
      CellTags->"Spanning"],
    Cell[71536, 2094, 216, 6, 49, "Usage",
      CellTags->"Spanning"],
    Cell[71755, 2102, 181, 3, 42, "Notes",
      CellTags->"Spanning"],
    Cell[71939, 2107, 409, 17, 42, "Notes",
      CellTags->"Spanning"]},
  "InsertRaw"->{
    Cell[72385, 2129, 65, 1, 35, "Command",
      CellTags->"InsertRaw"],
    Cell[72453, 2132, 275, 8, 49, "Usage",
      CellTags->"InsertRaw"],
    Cell[72731, 2142, 354, 8, 59, "Notes",
      CellTags->"InsertRaw"],
    Cell[73088, 2152, 1020, 30, 42, "Notes",
      CellTags->"InsertRaw"],
    Cell[74111, 2184, 233, 9, 25, "Notes",
      CellTags->"InsertRaw"]},
  "Make2D"->{
    Cell[74381, 2198, 48, 1, 35, "Command",
      CellTags->"Make2D"],
    Cell[74432, 2201, 220, 6, 49, "Usage",
      CellTags->"Make2D"],
    Cell[74655, 2209, 190, 8, 25, "Notes",
      CellTags->"Make2D"],
    Cell[74860, 2220, 717, 21, 25, "Notes",
      CellTags->"Make2D"]},
  "Balance"->{
    Cell[75602, 2245, 55, 1, 35, "Command",
      CellTags->"Balance"],
    Cell[75660, 2248, 421, 12, 49, "Usage",
      CellTags->"Balance"],
    Cell[76084, 2262, 113, 4, 25, "Notes",
      CellTags->"Balance"],
    Cell[76200, 2268, 406, 14, 75, "ItemizedText",
      CellTags->"Balance"],
    Cell[76609, 2284, 414, 11, 59, "Notes",
      CellTags->"Balance"],
    Cell[77026, 2297, 801, 21, 93, "Notes",
      CellTags->"Balance"],
    Cell[77830, 2320, 223, 7, 25, "Notes",
      CellTags->"Balance"],
    Cell[78056, 2329, 718, 21, 25, "Notes",
      CellTags->"Balance"]},
  "OptionsDialog"->{
    Cell[78811, 2355, 62, 1, 35, "Command",
      CellTags->"OptionsDialog"],
    Cell[78876, 2358, 218, 7, 32, "Usage",
      CellTags->"OptionsDialog"],
    Cell[79097, 2367, 169, 6, 25, "Notes",
      CellTags->"OptionsDialog"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Undo", 80008, 2397},
  {"Cut", 80347, 2408},
  {"Copy", 80762, 2421},
  {"Paste", 81186, 2434},
  {"Clear", 82106, 2461},
  {"PasteDiscard", 82397, 2470},
  {"CopySpecial", 82718, 2479},
  {"SelectionSaveSpecial", 82970, 2486},
  {"SelectAll", 83238, 2493},
  {"InsertObject", 83477, 2500},
  {"Motion", 85092, 2541},
  {"all", 85825, 2560},
  {"editmotion", 87064, 2589},
  {"ExpressionInput", 87170, 2592},
  {"editexpression", 87509, 2601},
  {"Spanning", 88081, 2614},
  {"InsertRaw", 88389, 2623},
  {"Make2D", 88772, 2634},
  {"Balance", 89070, 2643},
  {"OptionsDialog", 89673, 2660}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 43, 1, 35, "Command",
  CellTags->"Undo"],
Cell[1777, 54, 136, 5, 32, "Usage",
  CellTags->"Undo"],
Cell[1916, 61, 242, 4, 42, "Notes",
  CellTags->"Undo"],
Cell[2161, 67, 319, 7, 59, "Notes",
  CellTags->"Undo"],
Cell[2483, 76, 583, 18, 25, "Notes",
  CellTags->"Undo"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3103, 99, 41, 1, 35, "Command",
  CellTags->"Cut"],
Cell[3147, 102, 165, 5, 32, "Usage",
  CellTags->"Cut"],
Cell[3315, 109, 142, 3, 25, "Text",
  CellTags->"Cut"],
Cell[3460, 114, 243, 10, 50, "ItemizedText",
  CellTags->"Cut"],
Cell[3706, 126, 159, 5, 27, "NotesList",
  CellTags->"Cut"],
Cell[3868, 133, 582, 18, 25, "Notes",
  CellTags->"Cut"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4487, 156, 43, 1, 35, "Command",
  CellTags->"Copy"],
Cell[4533, 159, 194, 6, 32, "Usage",
  CellTags->"Copy"],
Cell[4730, 167, 145, 3, 25, "Notes",
  CellTags->"Copy"],
Cell[4878, 172, 248, 10, 50, "ItemizedText",
  CellTags->"Copy"],
Cell[5129, 184, 210, 6, 44, "NotesList",
  CellTags->"Copy"],
Cell[5342, 192, 583, 18, 25, "Notes",
  CellTags->"Copy"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5962, 215, 45, 1, 35, "Command",
  CellTags->"Paste"],
Cell[6010, 218, 155, 5, 32, "Usage",
  CellTags->"Paste"],
Cell[6168, 225, 130, 3, 25, "Notes",
  CellTags->"Paste"],
Cell[6301, 230, 288, 11, 50, "ItemizedText",
  CellTags->"Paste"],
Cell[6592, 243, 165, 3, 25, "Notes",
  CellTags->"Paste"],
Cell[6760, 248, 290, 11, 50, "ItemizedText",
  CellTags->"Paste"],
Cell[7053, 261, 205, 6, 27, "NotesList",
  CellTags->"Paste"],
Cell[7261, 269, 127, 3, 25, "Notes",
  CellTags->"Paste"],
Cell[7391, 274, 257, 10, 50, "ItemizedText",
  CellTags->"Paste"],
Cell[7651, 286, 228, 7, 27, "NotesList",
  CellTags->"Paste"],
Cell[7882, 295, 420, 10, 59, "Notes",
  CellTags->"Paste"],
Cell[8305, 307, 295, 5, 59, "Notes",
  CellTags->"Paste"],
Cell[8603, 314, 584, 18, 25, "Notes",
  CellTags->"Paste"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9224, 337, 45, 1, 35, "Command",
  CellTags->"Clear"],
Cell[9272, 340, 175, 5, 32, "Usage",
  CellTags->"Clear"],
Cell[9450, 347, 211, 7, 25, "Notes",
  CellTags->"Clear"],
Cell[9664, 356, 571, 17, 25, "Notes",
  CellTags->"Clear"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10272, 378, 64, 1, 35, "Command",
  CellTags->"PasteDiscard"],
Cell[10339, 381, 232, 6, 49, "Usage",
  CellTags->"PasteDiscard"],
Cell[10574, 389, 380, 9, 59, "Notes",
  CellTags->"PasteDiscard"],
Cell[10957, 400, 285, 8, 42, "Notes",
  CellTags->"PasteDiscard"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11279, 413, 53, 1, 35, "Command",
  CellTags->"CopySpecial"],
Cell[11335, 416, 176, 5, 32, "Usage",
  CellTags->"CopySpecial"],
Cell[11514, 423, 303, 5, 71, "Notes",
  CellTags->"CopySpecial"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11854, 433, 72, 1, 35, "Command",
  CellTags->"SelectionSaveSpecial"],
Cell[11929, 436, 202, 5, 32, "Usage",
  CellTags->"SelectionSaveSpecial"],
Cell[12134, 443, 434, 9, 88, "Notes",
  CellTags->"SelectionSaveSpecial"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12605, 457, 54, 1, 35, "Command",
  CellTags->"SelectAll"],
Cell[12662, 460, 160, 5, 32, "Usage",
  CellTags->"SelectAll"],
Cell[12825, 467, 609, 18, 25, "Notes",
  CellTags->"SelectAll"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13471, 490, 60, 1, 35, "Command",
  CellTags->"InsertObject"],
Cell[13534, 493, 229, 6, 49, "Usage",
  CellTags->"InsertObject"]
}, Open  ]],
Cell[13778, 502, 102, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[13883, 506, 93, 1, 23, "IndentedText",
  CellTags->"InsertObject"],
Cell[13979, 509, 103, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[14085, 513, 182, 4, 40, "IndentedText",
  CellTags->"InsertObject"],
Cell[14270, 519, 108, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[14381, 523, 79, 1, 23, "IndentedText",
  CellTags->"InsertObject"],
Cell[14463, 526, 96, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[14562, 530, 184, 4, 40, "IndentedText",
  CellTags->"InsertObject"],
Cell[14749, 536, 98, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[14850, 540, 146, 4, 23, "IndentedText",
  CellTags->"InsertObject"],
Cell[14999, 546, 96, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[15098, 550, 121, 3, 23, "IndentedText",
  CellTags->"InsertObject"],
Cell[15222, 555, 65, 1, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[15290, 558, 92, 1, 23, "IndentedText",
  CellTags->"InsertObject"],
Cell[15385, 561, 103, 2, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[15491, 565, 183, 4, 40, "IndentedText",
  CellTags->"InsertObject"],
Cell[15677, 571, 56, 1, 26, "DialogItem",
  CellTags->"InsertObject"],
Cell[15736, 574, 97, 1, 23, "IndentedText",
  CellTags->"InsertObject"],

Cell[CellGroupData[{
Cell[15858, 579, 47, 1, 35, "Command",
  CellTags->"Motion"],
Cell[15908, 582, 280, 7, 49, "Usage",
  CellTags->{"Motion", "all"}],
Cell[16191, 591, 39, 1, 25, "Notes",
  CellTags->"Motion"]
}, Open  ]],
Cell[16245, 595, 172, 6, 35, "Subsubsection",
  CellTags->{"Motion", "all"}],
Cell[16420, 603, 4424, 123, 233, "Text",
  CellTags->{"Motion", "all"}],
Cell[20847, 728, 181, 6, 35, "Subsubsection",
  CellTags->{"Motion", "all"}],
Cell[21031, 736, 11912, 314, 253, "Text",
  CellTags->{"Motion", "all"}],
Cell[32946, 1052, 166, 6, 35, "Subsubsection",
  CellTags->{"Motion", "all"}],
Cell[33115, 1060, 11964, 318, 253, "Text",
  CellTags->{"Motion", "all"}],
Cell[45082, 1380, 79, 2, 25, "Notes",
  CellTags->{"editmotion", "all"}],

Cell[CellGroupData[{
Cell[45186, 1386, 75, 4, 56, "Command",
  CellTags->"ExpressionInput"],
Cell[45264, 1392, 306, 7, 66, "Usage",
  CellTags->"ExpressionInput"],
Cell[45573, 1401, 48, 1, 25, "Notes",
  CellTags->"ExpressionInput"],
Cell[45624, 1404, 190, 6, 35, "Subsubsection",
  CellTags->{"editexpression", "all"}],
Cell[45817, 1412, 7556, 191, 359, "Text",
  CellTags->{"editexpression", "all"}],
Cell[53376, 1605, 245, 8, 35, "Subsubsection",
  CellTags->{"editexpression", "all"}],
Cell[53624, 1615, 8689, 225, 363, "Text",
  CellTags->{"editexpression", "all"}],
Cell[62316, 1842, 184, 6, 35, "Subsubsection",
  CellTags->{"editexpression", "all"}],
Cell[62503, 1850, 8689, 225, 363, "Text",
  CellTags->{"editexpression", "all"}],
Cell[71195, 2077, 239, 9, 25, "Notes",
  CellTags->"ExpressionInput"]
}, Open  ]],

Cell[CellGroupData[{
Cell[71471, 2091, 62, 1, 35, "Command",
  CellTags->"Spanning"],
Cell[71536, 2094, 216, 6, 49, "Usage",
  CellTags->"Spanning"],
Cell[71755, 2102, 181, 3, 42, "Notes",
  CellTags->"Spanning"],
Cell[71939, 2107, 409, 17, 42, "Notes",
  CellTags->"Spanning"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72385, 2129, 65, 1, 35, "Command",
  CellTags->"InsertRaw"],
Cell[72453, 2132, 275, 8, 49, "Usage",
  CellTags->"InsertRaw"],
Cell[72731, 2142, 354, 8, 59, "Notes",
  CellTags->"InsertRaw"],
Cell[73088, 2152, 1020, 30, 42, "Notes",
  CellTags->"InsertRaw"],
Cell[74111, 2184, 233, 9, 25, "Notes",
  CellTags->"InsertRaw"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74381, 2198, 48, 1, 35, "Command",
  CellTags->"Make2D"],
Cell[74432, 2201, 220, 6, 49, "Usage",
  CellTags->"Make2D"],
Cell[74655, 2209, 190, 8, 25, "Notes",
  CellTags->"Make2D"]
}, Open  ]],
Cell[74860, 2220, 717, 21, 25, "Notes",
  CellTags->"Make2D"],

Cell[CellGroupData[{
Cell[75602, 2245, 55, 1, 35, "Command",
  CellTags->"Balance"],
Cell[75660, 2248, 421, 12, 49, "Usage",
  CellTags->"Balance"],
Cell[76084, 2262, 113, 4, 25, "Notes",
  CellTags->"Balance"],
Cell[76200, 2268, 406, 14, 75, "ItemizedText",
  CellTags->"Balance"],
Cell[76609, 2284, 414, 11, 59, "Notes",
  CellTags->"Balance"],
Cell[77026, 2297, 801, 21, 93, "Notes",
  CellTags->"Balance"],
Cell[77830, 2320, 223, 7, 25, "Notes",
  CellTags->"Balance"],
Cell[78056, 2329, 718, 21, 25, "Notes",
  CellTags->"Balance"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78811, 2355, 62, 1, 35, "Command",
  CellTags->"OptionsDialog"],
Cell[78876, 2358, 218, 7, 32, "Usage",
  CellTags->"OptionsDialog"],
Cell[79097, 2367, 169, 6, 25, "Notes",
  CellTags->"OptionsDialog"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

